
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   PROCNMEA.H - NMEA Message Function Prototypes
// 
//
//   DESCRIPTION
//
//   Prototypes for the NMEA-0183 messsage processing and display functions.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Include\Archives\PROCNMEA.H_V  $
//   
//      Rev 1.15   06 Nov 1998 17:47:26   phungh
//   Labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the write to file code
//   portion out of the interrupt hander so that
//   data is not missed because of time spent
//   too long in the interrupt handler.
//   
//      Rev 1.4   Jul 09 1997 10:29:30   COLEJ
//    
//   
//      Rev 1.3   Feb 25 1997 14:39:14   COLEJ
//   changes to support .c file
//   
//      Rev 1.2   Feb 12 1997 16:04:42   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 15:08:08   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:54:28   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

void proc_alm(char *msgtmp[20]);
void proc_gga(char *msgtmp[20]);
void proc_gll(char *msgtmp[20]);
void proc_gsa(char *msgtmp[20]);
void proc_gsv(char *msgtmp[20]);
void proc_rmc(char *msgtmp[20]);
void proc_vtg(char *msgtmp[20]);
void proc_zda(char *msgtmp[20]);
void proc_alt(char *msgtmp[20]);
void proc_bit(char *msgtmp[20]);
void proc_com(char *msgtmp[20]);
void proc_dgp(char *msgtmp[20]);
void proc_zch(char *msgtmp[24]);
void proc_err(char *msgtmp[20]);
void proc_rid(char *msgtmp[20]);

void  get_nmea_vis_sats(short num_msg, char *msgtmp[20]);
void  show_nmea_vis_sats(short num_vis); 
void  show_utc(void); 
void  show_nmea_utc(char *msgtmp[1]);
short show_nmea_qual(char *msgtmp[1]);
void  show_nmea_op_mode(char *msgtmp[1]);
void  show_nmea_fix_mode(char *msgtmp[1]);
void  show_nmea_nsat(char *msgtmp[1]);
void  show_nmea_err(char *msgtmp[1]);
void  show_nmea_sats(char *msgtmp[12]);
void  show_nmea_chn_stat(short num_vis);
void  show_nmea_zchn_stat(char *msgtmp[24]);
void  show_nmea_pdop(char *msgtmp[1]);
void  show_nmea_hdop(char *msgtmp[1]);
void  show_nmea_vdop(char *msgtmp[1]);
void  show_nmea_alt(char *msgtmp[2]);
void  show_nmea_com(char *msgtmp[6]);
void  show_nmea_bit(char *msgtmp[11]);
void  show_nmea_dgp(char *msgtmp[12]);
void  show_nmea_stnid(char *msgtmp[1]);
short show_nmea_pos_stat(char *msgtmp[1]);  
void  show_nmea_sog(char *msgtmp[1]);
void  show_nmea_cog(char *msgtmp[1]);
void  show_nmea_date(char *msgtmp[1]);
void  show_nmea_mag(char *msgtmp[2]); 
void  show_nmea_dmy(char *msgtmp[3]);
void  show_nmea_lla(char *msglat[2],char *msglon[2],char *msgalt[2]); 

